/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.updphotos;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class TextUi {
    private PrintStream out = System.out;
    private BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    private boolean autodefault = System.getProperties().containsKey("autodefault");

    public TextUi() {
        if (this.autodefault) {
            this.out.println("WARNING : autodefault is enabled");
        }
    }

    public void printTitle(String text) {
        this.out.append("===").append(text).append("===").println();
    }

    public void printInfo(String text) {
        this.out.println(text);
    }

    public Boolean askBoolean(String question, Boolean defaultValue) {
        String value = this.askText(question, defaultValue == null ? "" : (defaultValue != false ? "y" : "n"), "y", "n");
        if (value.isEmpty()) {
            return null;
        }
        if (value.toLowerCase().equals("y")) {
            return true;
        }
        if (value.toLowerCase().equals("n")) {
            return false;
        }
        throw new RuntimeException("Bug detected in askText");
    }

    public Integer askInteger(String question, Integer defaultValue) {
        String value;
        while (!(value = this.askText(question, defaultValue == null ? "" : "" + defaultValue, new String[0])).isEmpty()) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                this.out.println("Mauvaise valeur entr\u00e9e, nombre entier attendu");
                continue;
            }
            break;
        }
        return null;
    }

    public String askText(String question) {
        return this.askText(question, null, new String[0]);
    }

    public String askText(String question, String defaultValue, String ... alternatives) {
        while (true) {
            block17: {
                String pro;
                int n;
                int n2;
                String[] stringArray;
                this.out.append(question);
                if (alternatives != null && alternatives.length > 0) {
                    this.out.append(" [");
                    boolean first = true;
                    stringArray = alternatives;
                    n2 = alternatives.length;
                    n = 0;
                    while (n < n2) {
                        pro = stringArray[n];
                        if (!first) {
                            this.out.append("/");
                        }
                        first = false;
                        this.out.append(pro.equals(defaultValue) ? pro.toUpperCase() : pro.toLowerCase());
                        ++n;
                    }
                    this.out.append("] ");
                } else if (defaultValue != null) {
                    this.out.append(" [").append(defaultValue).append("] ");
                } else {
                    this.out.append(" ");
                }
                if (this.autodefault && defaultValue != null) {
                    this.out.println("<autodefault " + defaultValue + ">");
                    return defaultValue;
                }
                try {
                    String value = this.in.readLine();
                    if (value.isBlank() && defaultValue != null) {
                        return defaultValue;
                    }
                    if (alternatives != null && alternatives.length > 0) {
                        stringArray = alternatives;
                        n2 = alternatives.length;
                        n = 0;
                        while (n < n2) {
                            pro = stringArray[n];
                            if (pro.toLowerCase().equals(value.toLowerCase())) {
                                return pro;
                            }
                            ++n;
                        }
                        break block17;
                    }
                    if (defaultValue == null) {
                        if (!value.isBlank()) {
                            return value;
                        }
                        break block17;
                    }
                    if (value.isBlank()) {
                        return defaultValue;
                    }
                    return value;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.out.println("Mauvaise valeur entr\u00e9e");
        }
    }
}

