/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.versionmanager;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public final class Configuration {
    private static final Properties PROPERTIES = new Properties();

    public static String getPrismInstallDirectory() {
        return PROPERTIES.getProperty("prism.install-directory");
    }

    public static String getPrismJarFilename() {
        return PROPERTIES.getProperty("prism.jar-filename");
    }

    public static String getSearchGroupId() {
        return PROPERTIES.getProperty("search.groupId");
    }

    public static String getSearchArtifactId() {
        String artifactId = PROPERTIES.getProperty("search.artifactId");
        return artifactId.isEmpty() ? null : artifactId;
    }

    public static boolean isSystemctlEnabled() {
        return Boolean.parseBoolean(PROPERTIES.getProperty("systemctl.enabled"));
    }

    public static String getProperty(String key) {
        return PROPERTIES.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return PROPERTIES.getProperty(key, defaultValue);
    }

    private Configuration() {
    }

    static {
        try (InputStream embeddedProperties = Configuration.class.getResourceAsStream("/config.properties");){
            PROPERTIES.load(embeddedProperties);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Path externalPropertiesPath = Path.of("config.properties", new String[0]);
        if (!Files.exists(externalPropertiesPath, new LinkOption[0])) {
            System.out.println("NOTICE: No external configuration file found, using default configuration.");
        } else {
            try (InputStream externalProperties = Files.newInputStream(externalPropertiesPath, new OpenOption[0]);){
                PROPERTIES.load(externalProperties);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

