/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.versionmanager;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.neogls.prism.versionmanager.Configuration;
import com.neogls.prism.versionmanager.model.nexus.AssetXO;
import com.neogls.prism.versionmanager.model.nexus.PageAssetXO;
import com.neogls.prism.versionmanager.util.QueryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.function.Consumer;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;

/*
 * Exception performing whole class analysis ignored.
 */
public class NexusMavenClient
implements AutoCloseable {
    private final Header authHeader;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final String BASE_URL = "https://maven.neogls.com/service/rest";

    public NexusMavenClient(String username, String password) {
        this.authHeader = NexusMavenClient.getAuthenticationHeader((String)username, (String)password);
        this.httpClient = HttpClients.createDefault();
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private HttpGet get(String uri) {
        HttpGet request = new HttpGet("https://maven.neogls.com/service/rest" + uri);
        request.addHeader(this.authHeader);
        return request;
    }

    private HttpGet download(AssetXO assetXO) {
        HttpGet request = new HttpGet(assetXO.getDownloadUrl());
        request.addHeader(this.authHeader);
        return request;
    }

    public boolean testAuth() throws IOException {
        return (Boolean)this.httpClient.execute((ClassicHttpRequest)this.get("/v1/repositories/maven-public"), response -> response.getCode() == 200);
    }

    public PageAssetXO searchAssets(boolean snapshots) throws IOException {
        String query = QueryBuilder.of((String)"/v1/search/assets").addParameter("sort", "version").addParameter("direction", "desc").addParameter("repository", snapshots ? "maven-snapshots" : "maven-releases").addParameter("maven.groupId", Configuration.getSearchGroupId()).addParameter("maven.artifactId", Configuration.getSearchArtifactId()).addParameter("maven.extension", "jar").addParameter("maven.classifier", "").buildToString();
        return (PageAssetXO)this.httpClient.execute((ClassicHttpRequest)this.get(query), response -> (PageAssetXO)this.objectMapper.readValue(response.getEntity().getContent(), PageAssetXO.class));
    }

    public void downloadAsset(AssetXO assetXO, Consumer<InputStream> responseHandler) throws IOException {
        this.httpClient.execute((ClassicHttpRequest)this.download(assetXO), response -> {
            if (response.getCode() == 200) {
                responseHandler.accept(response.getEntity().getContent());
            }
            return null;
        });
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private static Header getAuthenticationHeader(String username, String password) {
        return new BasicHeader("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes())));
    }
}

