/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.versionmanager.util;

import com.neogls.prism.versionmanager.Configuration;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;

public class InstalledVersionUtils {
    public static List<Path> getInstalledVersions() throws IOException {
        Path prismInstallDirectory = Path.of(Configuration.getPrismInstallDirectory(), new String[0]);
        try (DirectoryStream<Path> installedJars = Files.newDirectoryStream(prismInstallDirectory, entry -> Files.isRegularFile(entry, new LinkOption[0]) && !Files.isSymbolicLink(entry) && entry.getFileName().toString().endsWith(".jar"));){
            List<Path> list = StreamSupport.stream(installedJars.spliterator(), false).sorted(Comparator.comparing(Path::getFileName).reversed()).toList();
            return list;
        }
    }

    public static Path getCurrentVersion() throws IOException {
        Path prismInstallDirectory = Path.of(Configuration.getPrismInstallDirectory(), new String[0]);
        Path prismJarSymlink = prismInstallDirectory.resolve(Configuration.getPrismJarFilename());
        if (!Files.exists(prismJarSymlink, new LinkOption[0])) {
            return null;
        }
        if (!Files.isSymbolicLink(prismJarSymlink)) {
            System.out.printf("WARNING: %s is not a symbolic link%n", prismJarSymlink);
            return null;
        }
        return prismJarSymlink.toRealPath(new LinkOption[0]);
    }

    public static void setCurrentVersion(Path newCurrentVersion) throws IOException {
        Objects.requireNonNull(newCurrentVersion);
        Path prismInstallDirectory = Path.of(Configuration.getPrismInstallDirectory(), new String[0]);
        Path symlink = prismInstallDirectory.resolve(Configuration.getPrismJarFilename());
        Files.deleteIfExists(symlink);
        Files.createSymbolicLink(symlink, symlink.getParent().relativize(newCurrentVersion), new FileAttribute[0]);
    }

    private InstalledVersionUtils() {
    }
}

