/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.export;

import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismbatch.BusinessServiceFactory;
import com.geolocsystems.prismcentral.beans.Partenaire;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PrismIG4Export {
    private static final String EXPORT_IG4 = "export_ig4";
    private static Logger cat1 = Logger.getLogger((String)"exportIG4");

    public static void main(String[] args) {
        Date iterationCourante = GregorianCalendar.getInstance().getTime();
        cat1.info((Object)("Lancement \u00e0 " + iterationCourante));
        List partenaires = null;
        try {
            partenaires = BusinessServiceFactory.getBusinessService().getListePartenaire(ConstantesPrismCommun.EnumPartenaire.IG4_GAROU.getCode());
        }
        catch (Exception e1) {
            cat1.error((Object)"", (Throwable)e1);
            System.exit(1);
        }
        List<Partenaire> partenairesExternes = PrismIG4Export.recherchePartenaireExterne(partenaires);
        cat1.debug((Object)("Nombre de partenaires externe: " + partenairesExternes.size()));
        if (!BusinessServiceFactory.getSuiviActiviteService().exportation(partenairesExternes)) {
            System.exit(1);
        }
    }

    private static List<Partenaire> recherchePartenaireExterne(List<Partenaire> partenairesExternes) {
        Vector<Partenaire> partenairesATraiter = new Vector<Partenaire>();
        for (Partenaire partenaire : partenairesExternes) {
            if (!"CSV".equals(partenaire.getFormatEchange())) continue;
            partenairesATraiter.add(partenaire);
        }
        return partenairesATraiter;
    }
}

