/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prism.webservices.datex2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Properties;

public class ResourceProperties {
    private String bundleName = null;
    private Properties resourceBundle = null;

    public final String getString(String key) throws MissingResourceException {
        InputStream url;
        ClassLoader loader;
        if (this.resourceBundle == null && (loader = Thread.currentThread().getContextClassLoader()) != null && (url = loader.getResourceAsStream(this.bundleName)) != null) {
            this.resourceBundle = new Properties();
            try {
                this.resourceBundle.load(url);
            }
            catch (IOException e) {
                throw new MissingResourceException("Fichier non trouv\u00e9", ResourceProperties.class.getName(), this.bundleName);
            }
        }
        if (this.resourceBundle == null || this.resourceBundle.getProperty(key) == null) {
            throw new MissingResourceException("Valeur non trouv\u00e9e", ResourceProperties.class.getName(), key);
        }
        return this.resourceBundle.getProperty(key);
    }

    public final void setString(String key, String value) {
        if (this.resourceBundle == null) {
            this.getString(key);
        }
        this.resourceBundle.setProperty(key, value);
    }

    public final void setNomFichier(String nomFichier) {
        this.resourceBundle = null;
        this.bundleName = nomFichier;
    }

    public final void saveFichier() throws IOException, URISyntaxException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            URL url = loader.getResource(this.bundleName);
            FileOutputStream out = new FileOutputStream(new File(url.toURI()));
            this.resourceBundle.store(out, null);
        }
    }
}

