/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.updphotos;

import gls.outils.GLS;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class CompressUpdatePhotos {
    private PropertiesConfiguration config = new PropertiesConfiguration();
    private Connection co;
    private File base;

    public static void main(String[] args) throws Exception {
        CompressUpdatePhotos update = new CompressUpdatePhotos();
        update.doUpdate();
    }

    public CompressUpdatePhotos() throws IOException, SQLException, ClassNotFoundException {
        Class.forName(this.config.get("jdbc.driver"));
        this.co = DriverManager.getConnection(this.config.get("jdbc.url"), this.config.get("jdbc.username"), this.config.get("jdbc.password"));
        this.base = new File(this.config.get("photo.repertoire"));
    }

    public void doUpdate() throws SQLException {
        PreparedStatement pst = this.co.prepareStatement("SELECT k_eventid as id,snm,erf,photos FROM prism.evenement WHERE not photos IS NULL;");
        ResultSet rs = pst.executeQuery();
        int cpt = 0;
        while (rs.next()) {
            Evt evt = new Evt();
            evt.id = rs.getInt("id");
            evt.erf = rs.getString("erf");
            evt.snm = rs.getString("snm");
            Array photoArray = rs.getArray("photos");
            if (photoArray != null) {
                String[] photos = (String[])photoArray.getArray();
                ArrayList<String> photosList = new ArrayList<String>();
                photosList.addAll(Arrays.asList(photos));
                evt.photos = photosList;
            } else {
                evt.photos = new ArrayList<String>();
            }
            this.update(evt);
            ++cpt;
        }
        rs.close();
        pst.close();
        this.co.close();
        System.out.println(cpt + " evenements mis \u00e0 jours");
    }

    private void update(Evt e) throws SQLException {
        File dir = new File(this.base, String.valueOf(e.snm) + File.separator + e.erf);
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            ArrayList<String> photos = new ArrayList<String>();
            File[] afile = files;
            int j = files.length;
            int i = 0;
            while (i < j) {
                File file = afile[i];
                if (file.isFile() && GLS.estDansLaListe(e.photos, (Object)file.getName())) {
                    photos.add(file.getName());
                }
                ++i;
            }
            this.writePhotos(e, photos);
        }
    }

    private void writePhotos(Evt e, List photos) throws SQLException {
        PreparedStatement pst = this.co.prepareStatement("UPDATE prism.evenement SET photos=? WHERE k_eventid=?");
        Array a = this.co.createArrayOf("text", photos.toArray());
        pst.setArray(1, a);
        pst.setInt(2, e.id);
        pst.execute();
        pst.close();
        pst = null;
    }

    private class Evt {
        public int id;
        public String snm;
        public String erf;
        public List<String> photos;

        private Evt() {
        }
    }

    class PropertiesConfiguration {
        private static final String PRISM_CENTRAL_PROPERTIES = "config.properties";
        private Properties properties;

        public PropertiesConfiguration() throws IOException {
            File f = new File(PRISM_CENTRAL_PROPERTIES);
            FileInputStream inputStream = new FileInputStream(f);
            this.properties = new Properties();
            this.properties.load(inputStream);
            ((InputStream)inputStream).close();
        }

        public String get(String key) {
            if (this.properties.containsKey(key)) {
                return this.properties.getProperty(key);
            }
            throw new RuntimeException("Missing key " + key + " in file " + PRISM_CENTRAL_PROPERTIES);
        }

        public String get(String key, boolean mandatory) {
            if (this.properties.containsKey(key)) {
                return this.properties.getProperty(key);
            }
            if (mandatory) {
                throw new RuntimeException("Missing key " + key + " in file " + PRISM_CENTRAL_PROPERTIES);
            }
            return null;
        }

        public int getInt(String key) {
            String val = this.get(key);
            try {
                return Integer.parseInt(val);
            }
            catch (Exception e) {
                throw new RuntimeException("Unparsable int " + val + " for key " + key);
            }
        }

        public double getDouble(String key) {
            String val = this.get(key);
            try {
                return Double.parseDouble(val);
            }
            catch (Exception e) {
                throw new RuntimeException("Unparsable double " + val + " for key " + key);
            }
        }
    }
}

