/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel;

import net.schmizz.sshj.connection.ConnectionException;

public class OpenFailException
extends ConnectionException {
    private final String channelType;
    private final Reason reason;
    private final String message;

    public OpenFailException(String channelType, int reasonCode, String message) {
        super(message);
        this.channelType = channelType;
        this.reason = Reason.fromInt(reasonCode);
        this.message = message;
    }

    public OpenFailException(String channelType, Reason reason, String message) {
        super(message);
        this.channelType = channelType;
        this.reason = reason;
        this.message = message;
    }

    public String getChannelType() {
        return this.channelType;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public Reason getReason() {
        return this.reason;
    }

    @Override
    public String toString() {
        return "Opening `" + this.channelType + "` channel failed: " + this.getMessage();
    }

    public static enum Reason {
        UNKNOWN(0),
        ADMINISTRATIVELY_PROHIBITED(1),
        CONNECT_FAILED(2),
        UNKNOWN_CHANNEL_TYPE(3),
        RESOURCE_SHORTAGE(4);

        private final int code;

        public static Reason fromInt(int code) {
            Reason[] reasonArray = Reason.values();
            int n = reasonArray.length;
            int n2 = 0;
            while (n2 < n) {
                Reason rc = reasonArray[n2];
                if (rc.code == code) {
                    return rc;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        private Reason(int rc) {
            this.code = rc;
        }

        public int getCode() {
            return this.code;
        }
    }
}

