/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.schmizz.concurrent.Event;
import net.schmizz.sshj.AbstractService;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.AuthParams;
import net.schmizz.sshj.userauth.UserAuth;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AuthMethod;

public class UserAuthImpl
extends AbstractService
implements UserAuth {
    private final Event<UserAuthException> authenticated = new Event<UserAuthException>("authenticated", UserAuthException.chainer);
    private final Deque<UserAuthException> savedEx = new ArrayDeque<UserAuthException>();
    private volatile String banner = "";
    private volatile boolean partialSuccess;
    private Set<String> allowedMethods;
    private AuthMethod currentMethod;

    public UserAuthImpl(Transport trans) {
        super("ssh-userauth", trans);
    }

    @Override
    public synchronized void authenticate(String username, Service nextService, Iterable<AuthMethod> methods) throws UserAuthException, TransportException {
        this.savedEx.clear();
        super.request();
        if (this.allowedMethods == null) {
            this.allowedMethods = new HashSet<String>();
            for (AuthMethod meth : methods) {
                this.allowedMethods.add(meth.getName());
            }
        }
        try {
            AuthParams authParams = this.makeAuthParams(username, nextService);
            for (AuthMethod meth : methods) {
                if (!this.allowedMethods.contains(meth.getName())) {
                    this.saveException(new UserAuthException(String.valueOf(meth.getName()) + " auth not allowed by server"));
                    continue;
                }
                this.log.debug("Trying `{}` auth...", (Object)meth.getName());
                this.authenticated.clear();
                this.currentMethod = meth;
                try {
                    this.currentMethod.init(authParams);
                    this.currentMethod.request();
                    this.authenticated.await(this.timeout, TimeUnit.SECONDS);
                }
                catch (UserAuthException e) {
                    this.log.debug("`{}` auth failed", (Object)meth.getName());
                    this.saveException(e);
                    continue;
                }
                this.log.debug("`{}` auth successful", (Object)meth.getName());
                this.trans.setAuthenticated();
                this.trans.setService(nextService);
                return;
            }
        }
        finally {
            this.currentMethod = null;
        }
        this.log.debug("Had {} saved exception(s)", (Object)this.savedEx.size());
        throw new UserAuthException("Exhausted available authentication methods", (Throwable)this.savedEx.peek());
    }

    @Override
    public synchronized Deque<UserAuthException> getSavedExceptions() {
        return this.savedEx;
    }

    @Override
    public String getBanner() {
        return this.banner;
    }

    @Override
    public boolean hadPartialSuccess() {
        return this.partialSuccess;
    }

    @Override
    public void handle(Message msg, SSHPacket buf) throws SSHException {
        if (!msg.in(50, 80)) {
            throw new TransportException(DisconnectReason.PROTOCOL_ERROR);
        }
        switch (msg) {
            case USERAUTH_BANNER: {
                this.banner = buf.readString();
                break;
            }
            case USERAUTH_SUCCESS: {
                this.authenticated.set();
                break;
            }
            case USERAUTH_FAILURE: {
                this.allowedMethods.clear();
                this.allowedMethods.addAll(Arrays.asList(buf.readString().split(",")));
                this.partialSuccess |= buf.readBoolean();
                if (this.allowedMethods.contains(this.currentMethod.getName()) && this.currentMethod.shouldRetry()) {
                    this.currentMethod.request();
                    break;
                }
                this.authenticated.deliverError(new UserAuthException(String.valueOf(this.currentMethod.getName()) + " auth failed"));
                break;
            }
            default: {
                this.log.debug("Asking `{}` method to handle {} packet", (Object)this.currentMethod.getName(), (Object)msg);
                try {
                    this.currentMethod.handle(msg, buf);
                    break;
                }
                catch (UserAuthException e) {
                    this.authenticated.deliverError(e);
                }
            }
        }
    }

    @Override
    public void notifyError(SSHException error) {
        super.notifyError(error);
        this.authenticated.deliverError(error);
    }

    private AuthParams makeAuthParams(final String username, final Service nextService) {
        return new AuthParams(){

            @Override
            public String getNextServiceName() {
                return nextService.getName();
            }

            @Override
            public Transport getTransport() {
                return UserAuthImpl.this.trans;
            }

            @Override
            public String getUsername() {
                return username;
            }
        };
    }

    private void saveException(UserAuthException e) {
        this.log.debug("Saving for later - {}", (Object)e.toString());
        this.savedEx.push(e);
    }
}

