/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.versionmanager;

import com.neogls.prism.versionmanager.Configuration;
import com.neogls.prism.versionmanager.NexusMavenClient;
import com.neogls.prism.versionmanager.model.nexus.AssetXO;
import com.neogls.prism.versionmanager.model.nexus.Maven2Info;
import com.neogls.prism.versionmanager.model.nexus.PageAssetXO;
import com.neogls.prism.versionmanager.util.ConsoleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.math.NumberUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class InstallNewVersion {
    private static boolean askEnableSnapshots() {
        while (true) {
            String input;
            switch (input = System.console().readLine("Afficher les versions RELEASES (R) ou SNAPSHOTS (S) ? (d\u00e9faut : R) ", new Object[0])) {
                case "R": 
                case "r": 
                case "": {
                    return false;
                }
                case "S": 
                case "s": {
                    return true;
                }
            }
        }
    }

    private static int askVersion(PageAssetXO pageAsset) {
        int version;
        String inputStr;
        List assets = pageAsset.getItems();
        int assetNb = assets.size();
        for (int i = 0; i < assetNb; ++i) {
            AssetXO asset = (AssetXO)assets.get(i);
            Maven2Info maven2 = asset.getMaven2();
            if (maven2 == null) continue;
            System.out.printf("[%d] %s - %s%n", i + 1, maven2.getArtifactId(), maven2.getVersion());
        }
        if (pageAsset.getContinuationToken() != null) {
            System.out.println("[N] Page suivante");
        }
        System.out.println("[C] Annuler");
        System.out.println();
        do {
            if ("C".equals(inputStr = System.console().readLine("Choisir une version : ", new Object[0])) || "c".equals(inputStr)) {
                return -1;
            }
            if (pageAsset.getContinuationToken() == null || !"N".equals(inputStr) && !"n".equals(inputStr)) continue;
            return 0;
        } while (!NumberUtils.isDigits((String)inputStr) || (version = Integer.parseInt(inputStr)) <= 0 || version > assetNb);
        return version;
    }

    public static void installNewVersion() throws IOException {
        String username = System.console().readLine("Nexus username: ", new Object[0]);
        String password = String.valueOf(System.console().readPassword("Enter password: ", new Object[0]));
        try (NexusMavenClient client = new NexusMavenClient(username, password);){
            if (!client.testAuth()) {
                System.out.println("Authentication failed");
                ConsoleUtils.pressEnterToContinue();
                return;
            }
            boolean useSnapshots = InstallNewVersion.askEnableSnapshots();
            System.out.println();
            PageAssetXO pageAsset = client.searchAssets(useSnapshots);
            if (pageAsset.getItems().isEmpty()) {
                System.out.println("Aucune version disponible");
                System.out.println();
                ConsoleUtils.pressEnterToContinue();
                return;
            }
            int selectedVersion = InstallNewVersion.askVersion((PageAssetXO)pageAsset);
            if (selectedVersion == 0) {
                throw new RuntimeException("Not implemented");
            }
            AssetXO selectedAsset = (AssetXO)pageAsset.getItems().get(selectedVersion - 1);
            client.downloadAsset(selectedAsset, inputStream -> InstallNewVersion.handleDownload((AssetXO)selectedAsset, (InputStream)inputStream));
        }
        ConsoleUtils.pressEnterToContinue();
    }

    private static void handleDownload(AssetXO selectedAsset, InputStream inputStream) {
        block11: {
            Path fileName = Path.of(new URL(selectedAsset.getDownloadUrl()).getPath(), new String[0]).getFileName();
            Path downloadFilePath = Path.of(Configuration.getPrismInstallDirectory(), new String[0]).resolve(fileName);
            long actualFileSize = Files.copy(inputStream, downloadFilePath, new CopyOption[0]);
            if (actualFileSize != selectedAsset.getFileSize()) {
                throw new IllegalStateException("WARNING: File size doesn't match");
            }
            if (selectedAsset.getChecksum().containsKey("sha512")) {
                try (InputStream fileInputStream = Files.newInputStream(downloadFilePath, new OpenOption[0]);){
                    String computedSha512 = Hex.encodeHexString((byte[])DigestUtils.sha512((InputStream)fileInputStream));
                    if (!computedSha512.equals(selectedAsset.getChecksum().get("sha512"))) {
                        throw new IllegalStateException("Checksum doesn't match");
                    }
                    break block11;
                }
            }
            System.out.println("WARNING: Couldn't verify the checksum of the file");
        }
    }

    private InstallNewVersion() {
    }
}

