/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.versionmanager.util;

import com.neogls.prism.versionmanager.util.QueryBuilder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

final class QueryBuilderImpl
implements QueryBuilder {
    private final Map<String, String> parameters = new HashMap();
    private final String path;

    public QueryBuilderImpl(String path) {
        this.path = path;
    }

    public QueryBuilder addParameter(String name, String value) {
        if (value == null) {
            this.parameters.remove(name);
        } else {
            this.parameters.put(name, this.formatParameter(name, value));
        }
        return this;
    }

    private String formatParameter(String name, String value) {
        return URLEncoder.encode(name, StandardCharsets.UTF_8) + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public String buildToString() {
        if (this.parameters.isEmpty()) {
            return this.path;
        }
        String prefix = this.path + (this.path.contains("?") ? "&" : "?");
        return this.parameters.values().stream().collect(Collectors.joining("&", prefix, ""));
    }
}

